import sys, pygame, math, numpy, random, time, copy
from pygame.locals import * 

from constants import *
from utils import *
from core import *
from mycreatepathnetwork import *
from mynavigatorhelpers import *


###############################
### AStarNavigator
###
### Creates a path node network and implements the FloydWarshall all-pairs shortest-path algorithm to create a path to the given destination.
			
class AStarNavigator(Navigator):

	def __init__(self):
		Navigator.__init__(self)
		

	### Create the pathnode network and pre-compute all shortest paths along the network.
	### self: the navigator object
	### world: the world object
	def createPathNetwork(self, world):
		self.pathnodes, self.pathnetwork, self.navmesh = myCreatePathNetwork(world, self.agent)
		return None
		
	### Finds the shortest path from the source to the destination using A*.
	### self: the navigator object
	### source: the place the agent is starting from (i.e., it's current location)
	### dest: the place the agent is told to go to
	def computePath(self, source, dest):
		### Make sure the next and dist matricies exist
		if self.agent != None and self.world != None: 
			self.source = source
			self.destination = dest
			### Step 1: If the agent has a clear path from the source to dest, then go straight there.
			###   Determine if there are no obstacles between source and destination (hint: cast rays against world.getLines(), check for clearance).
			###   Tell the agent to move to dest
			### Step 2: If there is an obstacle, create the path that will move around the obstacles.
			###   Find the pathnodes closest to source and destination.
			###   Create the path by traversing the self.next matrix until the pathnode closes to the destination is reached
			###   Store the path by calling self.setPath()
			###   Tell the agent to move to the first node in the path (and pop the first node off the path)
			if clearShot(source, dest, self.world.getLines(), self.world.getPoints(), self.agent):
				self.agent.moveToTarget(dest)
			else:
				start = findClosestUnobstructed(source, self.pathnodes, self.world.getLinesWithoutBorders())
				end = findClosestUnobstructed(dest, self.pathnodes, self.world.getLinesWithoutBorders())
				if start != None and end != None:
					newnetwork = unobstructedNetwork(self.pathnetwork, self.world.getGates())
					closedlist = []
					path, closedlist = astar(start, end, newnetwork)
					if path is not None and len(path) > 0:
						path = shortcutPath(source, dest, path, self.world, self.agent)
						self.setPath(path)
						if self.path is not None and len(self.path) > 0:
							first = self.path.pop(0)
							self.agent.moveToTarget(first)
		return None
		
	### Called when the agent gets to a node in the path.
	### self: the navigator object
	def checkpoint(self):
		myCheckpoint(self)
		return None

	### This function gets called by the agent to figure out if some shortcutes can be taken when traversing the path.
	### This function should update the path and return True if the path was updated.
	def smooth(self):
		return mySmooth(self)

	def update(self, delta):
		myUpdate(self, delta)


def unobstructedNetwork(network, worldLines):
	newnetwork = []
	for l in network:
		hit = rayTraceWorld(l[0], l[1], worldLines)
		if hit == None:
			newnetwork.append(l)
	return newnetwork


### init : starting node
### goal : destination node
### network: list of lines in the path network that is not intersecting with world lines
def astar(init, goal, network):
	path = []
	open = []
	closed = []
	### YOUR CODE GOES BELOW HERE ###
        admissibleHeuristic = {}                # a dictionary that collects the perceived h(x) value for  each node evaluated
        Gx = {}                                 # a dictionary that collects the perceived g(x) value for each node evaluated
        prevNode = {}                           # a dictionary that holds the perceived parent node within the tentative path
        Gx[init]= 0
        current = None

        open.append(init)
	admissibleHeuristic[init] = 0 + distance(init,goal)

        currMin = -1
        closestPoint = None
        currMinGoal = -1
        closestPointGoal = None
        
	while open:
                #print open
                for possibleCurrentNode in open:
                        if current is None or admissibleHeuristic[possibleCurrentNode] < admissibleHeuristic[current]:
                                current = possibleCurrentNode
                                
                if current == goal or (closestPointGoal is not None and current == closestPointGoal) :
                        # construct the path with the references to previous points
                        path.append(current)
                        while current in prevNode:
                                current = prevNode[current]
                                path.append(current)

                        # reorganize into correct order
                        path.reverse()
                        return path, closed

                open.remove(current)
                closed.append(current)

                pathNodes = []
                # collect all possible paths if in the path network
                for line in network:
                        nodeA, nodeB = line

                        if nodeA not in pathNodes:
                                pathNodes.append(nodeA)

                        if nodeB not in pathNodes:
                                pathNodes.append(nodeB)

                                
                        visited = False
                        neighborNode = None
                        
                        if current in line:
                                existingPathNode = True
                                if current == nodeA:
                                        neighborNode = nodeB
                                        if neighborNode in closed:
                                                visited = True
                                else:
                                        neighborNode = nodeA
                                        if neighborNode in closed:
                                                visited = True

                                # neighbor node hasn't been evaluated 
                                if visited == False:
                                        predictedGx = Gx[current]+distance(neighborNode, current)

                                        if neighborNode not in open or predictedGx < Gx[neighborNode]:
                                                prevNode[neighborNode] = current
                                                Gx[neighborNode] = predictedGx
                                                admissibleHeuristic[neighborNode] = Gx[neighborNode]+distance(neighborNode,goal)

                                                if neighborNode not in open:
                                                        open.append(neighborNode)
        
                if current == init and len(open)==0:
                        for points in pathNodes:
                                if currMin == -1 or distance(current,points)<currMin:
                                        currMin = distance(current,points)
                                        closestPoint = points
                                if currMinGoal == -1 or distance(goal, points) < currMinGoal:
                                        currMinGoal = distance(goal,points)
                                        closestPointGoal = points
                                        
                        '''closestPoint = findClosestUnobstructed(init,pathNodes,world.getLines())'''
                        '''closestPointGoal = findClosestUnobstructed(init,pathNodes,world.getLines())'''

                        point = closestPoint
                                
                        predictedGx = Gx[current]+distance(point,current)

                        if point not in open or predictedGx< Gx[point]:
                                prevNode[point] = current
                                Gx[point] = predictedGx
                                admissibleHeuristic[point]= Gx[point]+distance(point,goal)

                                if point not in open:
                                        open.append(point)
                                        
                current = None

                                
	
	### YOUR CODE GOES ABOVE HERE ###
	return path, closed
	


def myUpdate(nav, delta):
	### YOUR CODE GOES BELOW HERE ###
        
        #nav.newnetwork = unobstructedNetwork(nav.pathnetwork,nav.world.getGates())
        
        if nav.path is not None:
                '''for i in range(0,len(nav.path)-1):'''
                if rayTraceWorld(nav.agent.moveOrigin,nav.agent.moveTarget,nav.world.getLines()):
                        nav.agent.stopMoving()
                        nav.checkpoint()


	### YOUR CODE GOES ABOVE HERE ###
	return None

def myCheckpoint(nav):
	### YOUR CODE GOES BELOW HERE ###
        
        nav.newnetwork = unobstructedNetwork(nav.pathnetwork,nav.world.getGates())
        astarTest = astar(nav.source,nav.destination,nav.newnetwork)
        if nav.path in astarTest[0] is False:
                nav.agent.stopMoving()
                nav.path, nav.closedList = astar(nav.source,nav.destination,nav.newnetwork)
        
        #if nav.destination not in nav.path:
        if len(nav.path)==0:

                nav.agent.stopMoving()
                nav.path = None
	### YOUR CODE GOES ABOVE HERE ###
	return None
